<?php 
   /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class Slider {
        private $db;
        private $id;
        private $nome;
        private $tipoTransizione;
        private $spazioOccupato;
        private $altezza;
        private $mostraFreccette;
        private $mostraPuntiNavigazione;
        private $autoplay;
        private $pausaOnHover;
        private $tempoPermanenzaSingolaSlide;
        private $slideMostrateSuLargeDesktop;
        private $slideMostrateSuDesktop;
        private $slideMostrateSuTablet;
        private $slideMostrateSuSmartphone;
        
        public function __construct($db, $id, $nome="", $tipoTransizione="", $spazioOccupato="col-12", $altezza="", $mostraFreccette="", $mostraPuntiNavigazione="", $autoplay="", $pausaOnHover = "", $tempoPermanenzaSingolaSlide = 3000, $slideMostrateSuLargeDesktop = 1, $slideMostrateSuDesktop = 1, $slideMostrateSuTablet = 1, $slideMostrateSuSmartphone = 1) {
            $this->db = $db;
            $this->id = $id;
            $this->nome = $nome;
            $this->tipoTransizione = $tipoTransizione;
            $this->spazioOccupato = $spazioOccupato;
            $this->altezza = $altezza;
            $this->mostraFreccette = $mostraFreccette;
            $this->mostraPuntiNavigazione = $mostraPuntiNavigazione;
            $this->autoplay = $autoplay;
            $this->pausaOnHover = $pausaOnHover;
            $this->tempoPermanenzaSingolaSlide = $tempoPermanenzaSingolaSlide;
            $this->slideMostrateSuLargeDesktop = $slideMostrateSuLargeDesktop;
            $this->slideMostrateSuDesktop = $slideMostrateSuDesktop;
            $this->slideMostrateSuTablet = $slideMostrateSuTablet;
            $this->slideMostrateSuSmartphone = $slideMostrateSuSmartphone;
        }

        function crea() {
            $query    = "INSERT INTO geec_slider VALUES(NULL,'$this->nome','$this->tipoTransizione','$this->spazioOccupato','$this->altezza','$this->mostraFreccette','$this->mostraPuntiNavigazione','$this->autoplay','$this->pausaOnHover','$this->tempoPermanenzaSingolaSlide','$this->slideMostrateSuLargeDesktop','$this->slideMostrateSuDesktop','$this->slideMostrateSuTablet','$this->slideMostrateSuSmartphone')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geec_slider SET nome='$this->nome', tipoTransizione='$this->tipoTransizione', spazioOccupato='$this->spazioOccupato', altezza='$this->altezza', mostraFreccette='$this->mostraFreccette', mostraPuntiNavigazione='$this->mostraPuntiNavigazione',autoplay='$this->autoplay', pausaOnHover='$this->pausaOnHover', tempoPermanenzaSingolaSlide='$this->tempoPermanenzaSingolaSlide', slideMostrateSuLargeDesktop='$this->slideMostrateSuLargeDesktop', slideMostrateSuDesktop='$this->slideMostrateSuDesktop', slideMostrateSuTablet='$this->slideMostrateSuTablet',slideMostrateSuSmartphone='$this->slideMostrateSuSmartphone' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_slider",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 24
            eliminaOccorrenzeComponente($this->db,$this->id,24);
        }
        
        function duplica() {
            $query    = "INSERT INTO geec_slider VALUES(NULL,'Copia di $this->nome')";
            $idNuovaForm = $this->db->eseguiQueryCreazione($query);
            
            $query       = "SELECT * FROM geec_slide WHERE idForm='$this->id'";
            $risElementi = $this->db->eseguiQueryLettura($query);
            while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                $query = "INSERT INTO `geec_slide` (`id`, `idForm`, `posizione`, `nome`, `etichetta`, `valore`, `placeholder`, `tipo`, `opzioni`, `obbligatorio`) "
                    . "VALUES (NULL, '$idNuovaForm', '{$elementoDaCopiare["posizione"]}', '{$elementoDaCopiare["nome"]}', '{$elementoDaCopiare["etichetta"]}', '{$elementoDaCopiare["valore"]}', '{$elementoDaCopiare["placeholder"]}', '{$elementoDaCopiare["tipo"]}', '{$elementoDaCopiare["opzioni"]}', '{$elementoDaCopiare["obbligatorio"]}')";
                $this->db->eseguiQueryCreazione($query);
            }
            return $idNuovaForm;
        }
        
        function duplicaElemento($idElemento,$prefisso = "Copia di ") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_slide WHERE id=$idElemento");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_slide SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_slide SET nome = CONCAT('$prefisso', ' ', nome), numeroClick=0 WHERE id=$idContenutoDuplicato");
            return $idContenutoDuplicato;
        }
        
        function caricaDatiDalDatabase() {
            $datiForm   = $this->db->leggiSingolaRiga("geec_slider",$this->id);
            $this->nome = $datiForm["nome"];
            $this->tipoTransizione = $datiForm["tipoTransizione"];
            $this->spazioOccupato  = $datiForm["spazioOccupato"];
            $this->altezza         = $datiForm["altezza"];
            $this->mostraFreccette = $datiForm["mostraFreccette"];
            $this->mostraPuntiNavigazione = $datiForm["mostraPuntiNavigazione"];
            $this->autoplay               = $datiForm["autoplay"];
            $this->pausaOnHover           = $datiForm["pausaOnHover"];
            $this->tempoPermanenzaSingolaSlide = $datiForm["tempoPermanenzaSingolaSlide"];
            $this->slideMostrateSuLargeDesktop = $datiForm["slideMostrateSuLargeDesktop"];
            $this->slideMostrateSuDesktop      = $datiForm["slideMostrateSuDesktop"];
            $this->slideMostrateSuTablet       = $datiForm["slideMostrateSuTablet"];
            $this->slideMostrateSuSmartphone   = $datiForm["slideMostrateSuSmartphone"];
        }
        
        function creaElemento($nome,$link) {
            $dataOggi       = date("Y-m-d H:i");
            $queryPosizione = "SELECT * FROM geec_slide WHERE idSlider=$this->id ORDER BY posizione DESC LIMIT 1";
            $risPosizione   = $this->db->eseguiQueryLettura($queryPosizione);
            $datiElemento   = $risPosizione->fetch_assoc();
            $posizione = ($risPosizione->num_rows>0) ? $datiElemento["posizione"] + 1 : 1;
            
            $query = "INSERT INTO `geec_slide` (`id`, `idSlider`, `posizione`, `nome`, `testo`, `tipo`, `percorsoFileMultimediale`, `link`, `overlay`, `gradiente`, `linkPulsante`, `stilePulsante`, `titoloPulsante`, `numeroClick`, `dataCreazione`, `dataUltimoClick`) VALUES
                                                (NULL, $this->id, $posizione, '$nome', '', 'sfondo', 'immagini/altro/segnaposto.png', '$link', 'no', 'no', '', '', '', 0, '$dataOggi', '$dataOggi')";
            $idElemento = $this->db->eseguiQueryCreazione($query);
            return $idElemento;
        }
        
        function stampaElementi() {
            
            $query = "SELECT * FROM geec_slide WHERE idSlider = {$this->id} ORDER BY posizione ASC";
            $risultatoQuery = $this->db->eseguiQueryLettura($query);
            while($slide = $risultatoQuery->fetch_assoc()) {
                
                $posizionePrecedente = ($slide["posizione"]<=1) ? 1 : $slide["posizione"] - 1;
                $posizioneSuccesiva  = $slide["posizione"] +1;
            ?>
                <div id="elementoComponente<?php echo $slide["id"] ?>" class="card-body mb-3 py-1 px-2 bg-light border rounded">
                    <div class="form-row">
                        <div class="col-xl-3 mb-2 mb-xl-0">
                            <?php 
                                if(strpos($slide["percorsoFileMultimediale"],".mp4")>0) {
                                    ?>
                                    <video width="100%" height="auto" controls>
                                        <source src="../../../<?= $slide["percorsoFileMultimediale"] ?>">
                                    </video>
                                    <?php
                                }
                                else {
                                    ?>
                                    <div class="aspect-ratio-21-9">
                                        <img src="../../../<?php echo $slide["percorsoFileMultimediale"] ?>">
                                    </div>
                                    <?php
                                }
                            ?>
                        </div>
                        <div class="col-md-8 col-xl-5 align-self-center mb-2 mb-md-0">
                            <p class="mb-0"><em><a href="creaElemento.php?id=<?php echo $slide["id"] ?>"><strong><?php echo $slide["nome"] ?></strong></a></em></p>
                            <small><em><?php echo $slide["numeroClick"] ?> click <?php echo(($slide["numeroClick"]>0) ? "- Ultimo: ".date("d/m/Y H:i",strtotime($slide["dataUltimoClick"])) : "") ?> </em>  </small>
                        </div>
                        <div class="col-md-4 col-xl-2 align-self-center">
                            <form>
                                <div class="input-group input-group-sm d-flex align-items-center">
                                    <small class="text-muted mr-2">Pos.</small>
                                    <input type="number" id="nuovaPosizioneElemento<?php echo $slide["id"]; ?>" class="form-control" aria-label="posizione" min="1" value="<?php echo $slide["posizione"] ?>">
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="button" onclick="spostaElementoInput(<?php echo $slide["id"]; ?>)">Salva</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-xl-2 align-self-center text-right azioni">
                            <div class="btn-group" role="group" aria-label="Basic example">
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" onclick="spostaElemento(<?php echo $slide["id"]; ?>,<?php echo $posizionePrecedente ?>)" data-original-title="Sposta su"><i class="fas fa-arrow-up"></i></button>
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" onclick="spostaElemento(<?php echo $slide["id"]; ?>,<?php echo $posizioneSuccesiva ?>)" data-original-title="Sposta giu"><i class="fas fa-arrow-down"></i></button>
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" onclick="location.href='creaElemento.php?id=<?php echo $slide["id"]; ?>';" data-original-title="Configura elemento"><i class="fas fa-cog"></i></button>
                                <button type="button" class="btn btn-light elimina" data-toggle="tooltip" data-placement="bottom"  onclick="eliminaElemento(<?php echo $slide["id"]; ?>,'<?php echo $slide["nome"]; ?>')" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
            <?php
            }
        }
        
        function modificaElemento($id,$nome,$link,$testo,$tipo,$overlay,$gradiente,$linkPulsante,$stilePulsante,$titoloPulsante) {
            $query = "UPDATE geec_slide SET nome='$nome', link='$link', testo='$testo', tipo='$tipo', overlay='$overlay', gradiente='$gradiente', linkPulsante='$linkPulsante', stilePulsante='$stilePulsante', titoloPulsante='$titoloPulsante' WHERE id=$id";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function cambiaFileMultimedialeElemento($idElemento,$percorsoFoto) {
            $query = "UPDATE `geec_slide` SET  percorsoFileMultimediale ='$percorsoFoto' WHERE id=$idElemento";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        function spostaElemento($idElemento,$posizione) {
            $queryPosizione = "SELECT * FROM geec_slide WHERE idSlider=$this->id AND id != $idElemento ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geec_slide SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geec_slide SET posizione=$posizione WHERE id = $idElemento ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function eliminaElemento($idElemento) {
            $this->db->eseguiQueryCancellazione("geec_slide",$idElemento);
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }
        
        public function getTipoTransizione() {
            return $this->tipoTransizione;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function getAltezza() {
            return $this->altezza;
        }

        public function getMostraFreccette() {
            return $this->mostraFreccette;
        }

        public function getMostraPuntiNavigazione() {
            return $this->mostraPuntiNavigazione;
        }

        public function getAutoplay() {
            return $this->autoplay;
        }

        public function getPausaOnHover() {
            return $this->pausaOnHover;
        }

        public function getTempoPermanenzaSingolaSlide() {
            return $this->tempoPermanenzaSingolaSlide;
        }

        public function getSlideMostrateSuLargeDesktop() {
            return $this->slideMostrateSuLargeDesktop;
        }

        public function getSlideMostrateSuDesktop() {
            return $this->slideMostrateSuDesktop;
        }

        public function getSlideMostrateSuTablet() {
            return $this->slideMostrateSuTablet;
        }

        public function getSlideMostrateSuSmartphone() {
            return $this->slideMostrateSuSmartphone;
        }

        public function setDb($db) {
            $this->db = $db;
        }

        public function setId($id) {
            $this->id = $id;
        }

        public function setNome($nome) {
            $this->nome = $nome;
        }
        
        public function setTipoTransizione($tipoTransizione) {
            $this->tipoTransizione = $tipoTransizione;
        }

        public function setSpazioOccupato($spazioOccupato) {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setAltezza($altezza) {
            $this->altezza = $altezza;
        }

        public function setMostraFreccette($mostraFreccette) {
            $this->mostraFreccette = $mostraFreccette;
        }

        public function setMostraPuntiNavigazione($mostraPuntiNavigazione) {
            $this->mostraPuntiNavigazione = $mostraPuntiNavigazione;
        }

        public function setAutoplay($autoplay) {
            $this->autoplay = $autoplay;
        }

        public function setPausaOnHover($pausaOnHover) {
            $this->pausaOnHover = $pausaOnHover;
        }

        public function setTempoPermanenzaSingolaSlide($tempoPermanenzaSingolaSlide) {
            $this->tempoPermanenzaSingolaSlide = $tempoPermanenzaSingolaSlide;
        }

        public function setSlideMostrateSuLargeDesktop($slideMostrateSuLargeDesktop) {
            $this->slideMostrateSuLargeDesktop = $slideMostrateSuLargeDesktop;
        }

        public function setSlideMostrateSuDesktop($slideMostrateSuDesktop) {
            $this->slideMostrateSuDesktop = $slideMostrateSuDesktop;
        }

        public function setSlideMostrateSuTablet($slideMostrateSuTablet) {
            $this->slideMostrateSuTablet = $slideMostrateSuTablet;
        }

        public function setSlideMostrateSuSmartphone($slideMostrateSuSmartphone) {
            $this->slideMostrateSuSmartphone = $slideMostrateSuSmartphone;
        }
    }